#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex FondCentre = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static WORD DistTab[256][256];
static WORD TanTab[256][256];

/*#define POS_X (64.f)
#define POS_Y (64.f)*/
#define POS_X (128.f)
#define POS_Y (128.f)

void LInit_Tunnel2d()
{
  double DistTmp, TanTmp;
  unsigned int Cpt1, Cpt2;
  float CenterX, CenterY;
  
	for(Cpt1=0;Cpt1<256;Cpt1++)
    {
		for(Cpt2=0;Cpt2<256;Cpt2++)
		{
			//DistTmp = sqrt((Cpt1-128.f)*(Cpt1-128.f)+(Cpt2-128.f)*(Cpt2-128.f))*1.41;
			//DistTmp = 4000/sqrt((Cpt1-POS_X)*(Cpt1-POS_X)+(Cpt2-POS_Y)*(Cpt2-POS_Y))*1.41;
			DistTmp = sqrt((Cpt1-128.f)*(Cpt1-128.f)+(Cpt2-128.f)*(Cpt2-128.f))*1.41;
			CenterX = ((int)Cpt1-128.f)*4+128.f;
			CenterY = ((int)Cpt2-128.f)*4+128.f;
			DistTmp = sqrt((Cpt1-CenterX)*(Cpt1-CenterX)+(Cpt2-CenterY)*(Cpt2-CenterY))*1.41;
			TanTmp = (atan2(Cpt1-128.f, Cpt2-128.f)/3.1415927*128.+128.);
			DistTab[Cpt1][Cpt2] = (DWORD)(8000/DistTmp)&255;
			TanTmp = (atan2(Cpt1-CenterX, Cpt2-CenterY)/3.1415927*128.+128.);
			//DistTab[Cpt1][Cpt2] = (WORD)(DistTmp * (1. + cos(TanTmp*PI2*5./256.)/4.))%256;
			TanTab[Cpt1][Cpt2] = (WORD)(TanTmp * 1.f)%256;
		}
    }
}

void QInit_Tunnel2d(){

  grConstantColorValue(192<<24);
  grSstControl(GR_CONTROL_ACTIVATE);
  
  grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
  grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
  /*grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
		 GR_COMBINE_FACTOR_LOCAL,*/
  grCullMode(GR_CULL_DISABLE);
  
  grChromakeyMode(GR_CHROMAKEY_DISABLE);
  grFogMode(GR_FOG_DISABLE);
  
  g_TextureBuff.info.format = GR_TEXFMT_RGB_565;
  SelectTexture(g_TextureBuff);
  memset(g_FrameBuf3d, 0, 65536*2);

}

void Effect_Tunnel2d()
{
	static WORD Img1=0, Img2=0;
	static DWORD dwTmp, Cpt1;

	if (g_demostate.TickInPattern<2500)
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
			 GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = 256*(2500-g_demostate.TickInPattern)/2500;
		dwTmp = CLIP_DW(dwTmp);
		dwTmp = dwTmp + (dwTmp<<8) + (dwTmp<<16);
		grConstantColorValue(dwTmp);
	}
	else
	{
	  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			 GR_COMBINE_FACTOR_LOCAL,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = 256*(5000-g_demostate.TickInPattern)/2500;
		dwTmp = CLIP_DW(dwTmp);
		dwTmp = dwTmp + (dwTmp<<8) + (dwTmp<<16);
		grConstantColorValue(dwTmp);
	}

	Img1 = g_demostate.TickInEffect/16;
	Img2 = g_demostate.TickInEffect/16;

#ifdef WIN32
	/*for(Cpt1=0;Cpt1<65536;Cpt1++){
	  ((WORD*)g_FrameBuf3d)[Cpt1] = g_PicTunnel2d[((DistTab[0][Cpt1]+Img1)&255) + (((TanTab[0][Cpt1]+Img2*2)&255)<<8) ];
	}*/
	_asm
	{
        /*push edi
        push ebp
        push eax
        push esi
        push ebx
        push ecx
        push edx*/
		pushad
		mov edi, g_FrameBuf3d
		mov ebp, OFFSET TanTab
		mov eax, OFFSET DistTab
		mov esi, g_PicTunnel2d
		mov ebx, 65536
		xor ecx, ecx
boucle:
		mov cx, WORD PTR[ebp+ebx*2-2]
		mov dx, WORD PTR[eax+ebx*2-2]
		add cx, Img1
		add dx, Img2
		and cx, 255
		and dx, 255
		shl cx, 8
		add cx,dx
		mov dx, WORD PTR[esi+ecx*2]
		mov WORD PTR[edi+ebx*2-2], dx
		dec ebx
		jnz boucle

		popad
        /*pop edx
        pop ecx
        pop ebx
        pop esi
        pop eax
        pop ebp
        pop edi*/
	}
#else
	__asm__ __volatile__("
                pushl %%edi\n
                pushl %%ebp\n
                pushl %%eax\n
                pushl %%esi\n
                pushl %%ebx\n
                pushl %%ecx\n
                pushl %%edx\n

		movl %0, %%edi\n
                movl %1, %%ebp\n
                movl %2, %%eax\n
                movl %3, %%esi\n
                movl $65536, %%ebx\n
                andl $0xffff, %%ecx\n
                andl $0xffff, %%edx\n
				xorl %%ecx, %%ecx\n
0:\n
                movw -2(%%ebp, %%ebx,2), %%cx\n
                movw -2(%%eax, %%ebx,2), %%dx\n
                addw %4, %%cx\n
                addw %5, %%dx\n
                andw $0xff, %%cx\n
                andw $0xff, %%dx\n
                shlw $8, %%cx\n
                addw %%dx, %%cx\n
                movw (%%esi, %%ecx, 2), %%dx\n
                movw %%dx, -2(%%edi, %%ebx, 2)\n
                sub $1, %%ebx\n
                jnz 0b\n

                popl %%edx\n
                popl %%ecx\n
                popl %%ebx\n
                popl %%esi\n
                popl %%eax\n
                popl %%ebp\n
                popl %%edi"
		:
		: "g" (g_FrameBuf3d), "g" (&TanTab[0]), "g" (&DistTab[0]), "g" (g_PicTunnel2d), "g" (Img1), "g" (Img2)
		);
#endif

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);

/*	FondCentre.x = 320 + 157*(float)(cos(Img1/110.f)+cos(Img1/30.f));
	FondCentre.y = 240 + 119*(float)(sin(Img1/73.f+.75f)+sin(Img1/25.f+.75f));
	FondCentre.tmuvtx[0].sow = (128 + 63*(float)(cos(Img1/110.f)+cos(Img1/30.f) ))*FondCentre.oow;
	FondCentre.tmuvtx[0].tow = (128 + 63*(float)(sin(Img1/73.f+.75f)+sin(Img1/25.f+.75f) ))*FondCentre.oow;
	FondCentre.r = 128 - 127.f * (float)cos(Img1/31.f);
	FondCentre.g = 128 - 127.f * (float)cos(Img1/36.f);
	FondCentre.b = 128 - 127.f * (float)cos(Img1/49.f);

	grDrawTriangle(&Fond1, &Fond2, &FondCentre);
	grDrawTriangle(&Fond2, &Fond3, &FondCentre);
	grDrawTriangle(&Fond3, &Fond4, &FondCentre);
	grDrawTriangle(&Fond1, &Fond4, &FondCentre);*/

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Tunnel2d()
{
	
}
